/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.ws.wsrr;

import filenet.vw.api.VWSession;
import filenet.vw.api.VWWorkflowSignature;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWQuickSort;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import filenet.vw.toolkit.utils.ws.VWUDDIBusinessServiceTableModel;
import filenet.vw.toolkit.utils.ws.VWWSWorkflow;
import filenet.vw.toolkit.utils.ws.base.wsrr.VWWSRRRegistryItem;
import filenet.vw.toolkit.utils.ws.wsrr.VWWSRRProcessMonitorDialog;
import filenet.vw.toolkit.utils.ws.wsrr.VWWSRRRegistryComboBoxRenderer;
import filenet.vw.toolkit.utils.ws.wsrr.VWWSRRRegistryManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public final class VWWSRRWorkflowPublishPanel
extends JPanel
implements ActionListener,
TableModelListener,
IVWToolbarBorderActionListener,
ListSelectionListener {
    private Frame m_parentFrame = null;
    private VWSession m_session = null;
    private VWWSRRRegistryManager m_wsrrRegistryManager = null;
    private VWWSWorkflow[] m_wsWorkflows = null;
    private JSplitPane m_mainPanel = null;
    private JPanel m_queryPanel = null;
    private JPanel m_selectedServicesPanel = null;
    private JTextField m_workflowQueryNameUI = null;
    private JButton m_serchButton = null;
    private WorkflowQuery m_workflowQueryObject = null;
    private VWTable m_queryServicesTable = null;
    private VWUDDIBusinessServiceTableModel m_queryServicesTableModel = null;
    private VWToolbarBorder m_queryServicesToolbarBorder = null;
    private ListSelectionModel m_queryServicesTableListSelectionModel = null;
    private VWTable m_selectedServicesTable = null;
    private VWUDDIBusinessServiceTableModel m_selectedServicesTableModel = null;
    private VWToolbarBorder m_selectedServicesToolbarBorder = null;
    private ListSelectionModel m_selectedServicesListSelectionModel = null;
    private boolean m_bFirstTime = false;
    private JComboBox m_wsrrRegistryCombo = null;
    private JButton m_publishButton = null;

    public static String _get_FILE_DATE() {
        return "$Date:   13 Feb 2009 17:56:50  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   dsiegfried  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.7  $";
    }

    public VWWSRRWorkflowPublishPanel(Frame parent, VWSession session, VWWSRRRegistryManager wsrrRegistryManager) {
        super(new BorderLayout(5, 5));
        this.m_parentFrame = parent;
        this.m_session = session;
        this.m_wsrrRegistryManager = wsrrRegistryManager;
        this.m_wsrrRegistryCombo = new JComboBox();
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.m_wsrrRegistryCombo.getModel();
        if (model != null) {
            model.removeAllElements();
            model.addElement(VWResource.s_ellipse.toString(VWResource.s_validatingServerCertificate));
            this.m_wsrrRegistryCombo.setSelectedIndex(0);
        }
        this.m_workflowQueryObject = new WorkflowQuery();
        this.createQueryPanel();
        this.createSelectedServicesPanel();
        this.m_mainPanel = new JSplitPane(0, this.m_queryPanel, this.m_selectedServicesPanel);
        VWAccessibilityHelper.setAccessibility(this.m_queryPanel, this.m_mainPanel, null, null);
        VWAccessibilityHelper.setAccessibility(this.m_selectedServicesPanel, this.m_mainPanel, null, null);
        this.m_mainPanel.setToolTipText(VWResource.s_slideToAdjustView);
        this.m_mainPanel.setOneTouchExpandable(true);
        this.m_mainPanel.setDividerSize(6);
        this.m_mainPanel.setDividerLocation(200);
        this.setLayout(new BorderLayout(3, 3));
        this.add((Component)this.m_mainPanel, "Center");
        VWAccessibilityHelper.setAccessibility(this.m_mainPanel, this, null, null);
        JPanel bottomPanel = this.createBottomPanel();
        this.add((Component)bottomPanel, "Last");
        VWAccessibilityHelper.setAccessibility(bottomPanel, this, null, null);
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.m_bFirstTime) {
            this.m_bFirstTime = false;
            if (this.m_mainPanel != null) {
                this.m_mainPanel.setDividerLocation(200);
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.m_workflowQueryNameUI) {
            this.executeWorkflowQuery();
        } else if (source == this.m_serchButton) {
            this.executeWorkflowQuery();
        } else if (source == this.m_publishButton) {
            this.publish();
        } else if (source == this.m_wsrrRegistryCombo) {
            this.onRegistrySelection();
        }
        this.setTableFocusableState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        try {
            try {
                switch (event.getID()) {
                    case 0x10000000: {
                        int[] rows = this.m_selectedServicesTable.getSelectedRows();
                        for (int nIndex = rows.length - 1; nIndex >= 0; --nIndex) {
                            this.m_selectedServicesTableModel.removeRow(rows[nIndex]);
                        }
                        break;
                    }
                    case 0x1000000: {
                        int nIndex;
                        int[] rows = this.m_queryServicesTable.getSelectedRows();
                        Vector<VWWSWorkflow> WFVector = new Vector<VWWSWorkflow>();
                        for (nIndex = 0; nIndex < rows.length; ++nIndex) {
                            VWWSWorkflow selectedWF = this.m_queryServicesTableModel.getWorkflowAt(rows[nIndex]);
                            int idx = this.m_selectedServicesTableModel.find(selectedWF);
                            if (idx >= 0) {
                                this.m_selectedServicesTableModel.removeRow(idx);
                            }
                            WFVector.add(selectedWF);
                        }
                        if (WFVector.size() > 0) {
                            this.m_selectedServicesTableModel.addData(WFVector);
                        }
                        for (nIndex = rows.length - 1; nIndex >= 0; --nIndex) {
                            this.m_queryServicesTableModel.removeRow(rows[nIndex]);
                        }
                    }
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                Object var8_11 = null;
                this.setTableFocusableState();
                return;
            }
            Object var8_10 = null;
            this.setTableFocusableState();
            return;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            this.setTableFocusableState();
            throw throwable;
        }
    }

    public void addNotify() {
        super.addNotify();
        this.setTableFocusableState();
    }

    public void valueChanged(ListSelectionEvent event) {
        Object source = event.getSource();
        if (source == this.m_selectedServicesListSelectionModel) {
            if (!event.getValueIsAdjusting()) {
                JPanel clientPanel = this.m_selectedServicesToolbarBorder.getClientPanel();
                int nRowIndex = this.m_selectedServicesTable.getSelectedRow();
                int nRowCount = this.m_selectedServicesTable.getRowCount();
                if (this.m_selectedServicesTableModel != null && nRowIndex != -1) {
                    this.m_selectedServicesToolbarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(clientPanel, 1, 0x10000000));
                } else {
                    this.m_selectedServicesToolbarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(clientPanel, 2, 0x10000000));
                }
            }
        } else if (source == this.m_queryServicesTableListSelectionModel && !event.getValueIsAdjusting()) {
            JPanel clientPanel = this.m_queryServicesToolbarBorder.getClientPanel();
            int nRowIndex = this.m_queryServicesTable.getSelectedRow();
            int nRowCount = this.m_queryServicesTable.getRowCount();
            if (this.m_queryServicesTableModel != null && nRowIndex != -1) {
                this.m_queryServicesToolbarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(clientPanel, 1, 0x1000000));
            } else {
                this.m_queryServicesToolbarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(clientPanel, 2, 0x1000000));
            }
        }
    }

    public void tableChanged(TableModelEvent event) {
        switch (event.getType()) {
            case 1: {
                if (this.m_selectedServicesTable.getRowCount() <= 0) break;
                int lastRow = event.getLastRow() - 1;
                int firstRow = event.getFirstRow();
                if (lastRow < 0) {
                    lastRow = 0;
                }
                if (lastRow == this.m_selectedServicesTable.getSelectedRow()) {
                    this.m_selectedServicesTable.clearSelection();
                }
                this.m_selectedServicesTable.setRowSelectionInterval(firstRow, lastRow);
                this.m_selectedServicesTable.ensureRowIsVisible(lastRow);
            }
        }
        this.setTableFocusableState();
    }

    protected void initData(VWWSRRRegistryManager wsrrRegistryManager) {
        VWWSRRRegistryItem[] wsrrRegistryItemArray = null;
        if (wsrrRegistryManager != null) {
            wsrrRegistryItemArray = wsrrRegistryManager.getWSRRRegistryItemList();
        }
        if (wsrrRegistryItemArray != null) {
            this.initWSRRReigstryComboBox(wsrrRegistryItemArray);
        } else {
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.m_wsrrRegistryCombo.getModel();
            if (model != null) {
                model.removeAllElements();
                this.m_wsrrRegistryCombo.setSelectedIndex(-1);
            }
        }
    }

    private void setTableFocusableState() {
        this.m_queryServicesTable.setFocusable(this.m_queryServicesTable.getRowCount() > 0);
        this.m_selectedServicesTable.setFocusable(this.m_selectedServicesTable.getRowCount() > 0);
    }

    private void createQueryPanel() {
        this.m_queryPanel = new JPanel();
        this.m_queryPanel.setLayout(new BorderLayout(4, 4));
        VWToolbarBorder searchToolbarBorder = new VWToolbarBorder(VWResource.s_searchWebServicesWorkflows, 0);
        JPanel panel = searchToolbarBorder.getClientPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0));
        panel.setLayout(new GridBagLayout());
        VWAccessibilityHelper.setAccessibility(panel, searchToolbarBorder, null, null);
        this.m_workflowQueryNameUI = new JTextField();
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.anchor = 23;
        c.fill = 1;
        panel.add((Component)this.m_workflowQueryNameUI, c);
        JLabel label = searchToolbarBorder.getTitleLabel();
        VWAccessibilityHelper.setLabelFor(label, this.m_workflowQueryNameUI);
        VWAccessibilityHelper.setAccessibility(this.m_workflowQueryNameUI, panel, VWResource.s_searchWebServicesWorkflows, VWResource.s_searchWebServicesWorkflows);
        this.m_serchButton = new JButton(VWImageLoader.createImageIcon("search.gif"));
        this.m_serchButton.setName("m_searchButton");
        this.m_serchButton.addActionListener(this);
        c.gridx = 1;
        c.weightx = 0.0;
        panel.add((Component)this.m_serchButton, c);
        VWAccessibilityHelper.setAccessibility(this.m_serchButton, panel, VWResource.s_searchWebServicesWorkflows + VWResource.s_search, VWResource.s_searchWebServicesWorkflows + VWResource.s_search);
        this.m_queryServicesToolbarBorder = new VWToolbarBorder(VWResource.s_webServicesWorkflowsSearchResult, 0x1000000);
        this.m_queryServicesToolbarBorder.addToolbarBorderActionNotifier(this);
        panel = this.m_queryServicesToolbarBorder.getClientPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0));
        panel.setLayout(new BorderLayout(4, 4));
        this.initWebServicesWorkflowTable();
        panel.add((Component)new JScrollPane(this.m_queryServicesTable), "Center");
        VWAccessibilityHelper.setAccessibility(panel, this.m_queryServicesToolbarBorder, null, null);
        VWAccessibilityHelper.setAccessibility(this.m_queryServicesTable, panel, VWResource.s_webServicesWorkflowsSearchResultTable, VWResource.s_webServicesWorkflowsSearchResultTable);
        label = this.m_queryServicesToolbarBorder.getTitleLabel();
        this.m_queryPanel.add((Component)searchToolbarBorder, "First");
        this.m_queryPanel.add((Component)this.m_queryServicesToolbarBorder, "Center");
        VWAccessibilityHelper.setAccessibility(searchToolbarBorder, this.m_queryPanel, null, null);
        VWAccessibilityHelper.setAccessibility(this.m_queryServicesToolbarBorder, this.m_queryPanel, null, null);
    }

    private void createSelectedServicesPanel() {
        this.m_selectedServicesPanel = new JPanel();
        this.m_selectedServicesPanel.setLayout(new BorderLayout(4, 4));
        this.m_selectedServicesToolbarBorder = new VWToolbarBorder(VWResource.s_webServicesWorkflowsToPublish, 0x10000000);
        this.m_selectedServicesToolbarBorder.addToolbarBorderActionNotifier(this);
        JPanel panel = this.m_selectedServicesToolbarBorder.getClientPanel();
        VWAccessibilityHelper.setAccessibility(panel, this.m_selectedServicesToolbarBorder, null, null);
        panel.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0));
        panel.setLayout(new BorderLayout(4, 4));
        this.initSelectedServicesTable();
        panel.add((Component)new JScrollPane(this.m_selectedServicesTable), "Center");
        this.m_selectedServicesPanel.add((Component)this.m_selectedServicesToolbarBorder, "Center");
        VWAccessibilityHelper.setAccessibility(this.m_selectedServicesTable, panel, VWResource.s_webServicesWorkflowsToPublish, VWResource.s_webServicesWorkflowsToPublish);
        JLabel label = this.m_selectedServicesToolbarBorder.getTitleLabel();
    }

    private JPanel createBottomPanel() {
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BorderLayout(4, 4));
        VWToolbarBorder wsrrRegistryToolbarBorder = new VWToolbarBorder(VWResource.s_selectWSRRRegistry, 0);
        JPanel panel = wsrrRegistryToolbarBorder.getClientPanel();
        VWAccessibilityHelper.setAccessibility(panel, wsrrRegistryToolbarBorder, null, null);
        panel.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        panel.add((Component)this.m_wsrrRegistryCombo, c);
        VWAccessibilityHelper.setAccessibility(this.m_wsrrRegistryCombo, panel, VWResource.s_selectWSRRRegistry, VWResource.s_selectWSRRRegistry);
        JLabel label = wsrrRegistryToolbarBorder.getTitleLabel();
        VWAccessibilityHelper.setLabelFor(label, this.m_wsrrRegistryCombo);
        this.m_publishButton = new JButton(VWResource.s_publish);
        this.m_publishButton.setEnabled(false);
        this.m_publishButton.addActionListener(this);
        c.weightx = 0.0;
        c.weighty = 0.0;
        ++c.gridx;
        c.fill = 0;
        c.anchor = 22;
        panel.add((Component)this.m_publishButton, c);
        VWAccessibilityHelper.setAccessibility(this.m_publishButton, panel, VWResource.s_publish, VWResource.s_publish);
        bottomPanel.add((Component)wsrrRegistryToolbarBorder, "Center");
        VWAccessibilityHelper.setAccessibility(wsrrRegistryToolbarBorder, bottomPanel, null, null);
        return bottomPanel;
    }

    private void initSelectedServicesTable() {
        this.m_selectedServicesTableModel = new VWUDDIBusinessServiceTableModel();
        this.m_selectedServicesTable = new VWTable(this.m_selectedServicesTableModel);
        this.m_selectedServicesTableModel.addTableModelListener(this);
        this.m_selectedServicesTable.setRowSelectionAllowed(true);
        this.m_selectedServicesListSelectionModel = this.m_selectedServicesTable.getSelectionModel();
        this.m_selectedServicesListSelectionModel.addListSelectionListener(this);
        this.m_selectedServicesTable.getSelectionModel().addListSelectionListener(this);
        this.m_selectedServicesTable.setEnabled(true);
        if (this.m_selectedServicesTable.getRowCount() > 0) {
            this.m_selectedServicesTable.setRowSelectionInterval(0, 0);
        } else {
            this.m_selectedServicesToolbarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_selectedServicesToolbarBorder.getClientPanel(), 2, 0x10000000));
        }
    }

    public void resetSelectedServicesTableModel() {
        this.m_selectedServicesTableModel = new VWUDDIBusinessServiceTableModel();
        this.m_selectedServicesTable.setModel(this.m_selectedServicesTableModel);
    }

    private void initWebServicesWorkflowTable() {
        this.m_queryServicesTableModel = new VWUDDIBusinessServiceTableModel();
        this.m_queryServicesTable = new VWTable(this.m_queryServicesTableModel);
        this.m_queryServicesTableModel.addTableModelListener(this.m_queryServicesTable);
        this.m_queryServicesTable.setRowSelectionAllowed(true);
        this.m_queryServicesTableListSelectionModel = this.m_queryServicesTable.getSelectionModel();
        this.m_queryServicesTable.getSelectionModel().addListSelectionListener(this);
        this.m_queryServicesTable.setEnabled(true);
        if (this.m_queryServicesTable.getRowCount() > 0) {
            this.m_queryServicesTable.setRowSelectionInterval(0, 0);
        } else {
            this.m_queryServicesToolbarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_queryServicesToolbarBorder.getClientPanel(), 2, 0x1000000));
        }
    }

    public void resetWebServicesWorkflowTableModel() {
        this.m_queryServicesTableModel = new VWUDDIBusinessServiceTableModel();
        this.m_queryServicesTable.setModel(this.m_queryServicesTableModel);
    }

    private void initWSRRReigstryComboBox(VWWSRRRegistryItem[] wsrrRegistryItemArray) {
        if (wsrrRegistryItemArray != null) {
            this.m_wsrrRegistryCombo.removeAllItems();
            Object obj = null;
            String registryName = null;
            for (int i = 0; i < wsrrRegistryItemArray.length; ++i) {
                if (wsrrRegistryItemArray[i] == null) continue;
                registryName = wsrrRegistryItemArray[i].getHostName();
                String name = null;
                boolean bInserted = false;
                int listSz = this.m_wsrrRegistryCombo.getItemCount();
                for (int j = 0; j < listSz; ++j) {
                    obj = this.m_wsrrRegistryCombo.getItemAt(j);
                    if (obj == null || !(obj instanceof VWWSRRRegistryItem) || !((VWWSRRRegistryItem)obj).getPublish() || VWStringUtils.compareIgnoreCase(registryName, name = ((VWWSRRRegistryItem)obj).getHostName()) >= 0) continue;
                    this.m_wsrrRegistryCombo.insertItemAt(wsrrRegistryItemArray[i], j);
                    bInserted = true;
                    break;
                }
                if (bInserted) continue;
                this.m_wsrrRegistryCombo.addItem(wsrrRegistryItemArray[i]);
            }
        }
        this.m_wsrrRegistryCombo.setSelectedIndex(-1);
        this.m_wsrrRegistryCombo.setRenderer(new VWWSRRRegistryComboBoxRenderer());
        this.m_wsrrRegistryCombo.addActionListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executeWorkflowQuery() {
        if (this.m_workflowQueryObject == null) return;
        Cursor currentCursor = null;
        try {
            block9: {
                try {
                    currentCursor = this.getCursor();
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    if (this.m_workflowQueryNameUI == null) break block9;
                    this.m_wsWorkflows = this.m_workflowQueryObject.findWorkflowByName(this.m_workflowQueryNameUI.getText());
                    if (this.m_wsWorkflows != null && this.m_wsWorkflows.length > 0) {
                        VWQuickSort sort = new VWQuickSort(this.m_wsWorkflows, 0);
                        sort.sort(0, this.m_wsWorkflows.length - 1);
                    }
                    if (this.m_queryServicesTableModel == null) {
                        this.m_queryServicesTableModel = new VWUDDIBusinessServiceTableModel(this.m_wsWorkflows);
                        if (this.m_queryServicesTable == null) {
                            this.m_queryServicesTable = new VWTable(this.m_queryServicesTableModel);
                        } else {
                            this.m_queryServicesTable.setModel(this.m_queryServicesTableModel);
                        }
                    } else {
                        this.m_queryServicesTableModel.setData(this.m_wsWorkflows);
                    }
                    this.m_queryServicesTableModel.fireTableDataChanged();
                }
                catch (Exception ex) {
                    this.showMessage(VWResource.s_failedToQueryForProcesses, VWResource.s_error, 1, ex);
                    VWDebug.logException(ex);
                    Object var4_5 = null;
                    if (currentCursor == null) return;
                    this.setCursor(currentCursor);
                    return;
                }
            }
            Object var4_4 = null;
            if (currentCursor == null) return;
            this.setCursor(currentCursor);
            return;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            if (currentCursor == null) throw throwable;
            this.setCursor(currentCursor);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void publish() {
        Cursor currentCursor;
        block15: {
            block14: {
                block13: {
                    block12: {
                        block11: {
                            currentCursor = null;
                            try {
                                try {
                                    VWWSWorkflow[] selectedWorkflows = null;
                                    VWWSRRRegistryItem selectedWSRRRegistry = null;
                                    if (this.m_selectedServicesTableModel != null) {
                                        selectedWorkflows = this.m_selectedServicesTableModel.getData();
                                    }
                                    if (this.m_wsrrRegistryCombo != null) {
                                        Object obj = this.m_wsrrRegistryCombo.getSelectedItem();
                                        selectedWSRRRegistry = obj instanceof VWWSRRRegistryItem ? (VWWSRRRegistryItem)obj : null;
                                    }
                                    if (this.m_selectedServicesTableModel.getRowCount() == 0) {
                                        this.showMessage(VWResource.s_pleaseSearchAndSelectWorkflowsToPublish, VWResource.s_publishing, 2);
                                        Object var6_6 = null;
                                        if (currentCursor == null) return;
                                        break block11;
                                    }
                                    if (selectedWorkflows == null || selectedWorkflows.length == 0) {
                                        this.showMessage(VWResource.s_pleaseSelectOneOrMoreWorkflowsToPublish, VWResource.s_publishing, 2);
                                        break block12;
                                    }
                                    if (selectedWSRRRegistry == null) {
                                        this.showMessage(VWResource.s_pleaseSelectAWsrrRegistryForPublishing, VWResource.s_publishing, 2);
                                        break block13;
                                    }
                                    if (this.m_wsrrRegistryManager.authenticateForPublish(this.m_parentFrame, selectedWSRRRegistry) != VWWSRRRegistryManager.WSRR_AUTHENTICATE_SUCCESS) {
                                        break block14;
                                    }
                                    VWWSRRProcessMonitorDialog publishMonitor = new VWWSRRProcessMonitorDialog(this.m_parentFrame, this.m_wsrrRegistryManager, selectedWSRRRegistry, selectedWorkflows, 1, VWResource.s_publishWorkflow);
                                    publishMonitor.setVisible(true);
                                    publishMonitor.releaseResources();
                                    break block15;
                                }
                                catch (Exception ex) {
                                    VWDebug.logException(ex);
                                    Object var6_11 = null;
                                    if (currentCursor == null) return;
                                    this.setCursor(currentCursor);
                                    return;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var6_12 = null;
                                if (currentCursor == null) throw throwable;
                                this.setCursor(currentCursor);
                                throw throwable;
                            }
                        }
                        this.setCursor(currentCursor);
                        return;
                    }
                    Object var6_7 = null;
                    if (currentCursor == null) return;
                    this.setCursor(currentCursor);
                    return;
                }
                Object var6_8 = null;
                if (currentCursor == null) return;
                this.setCursor(currentCursor);
                return;
            }
            Object var6_9 = null;
            if (currentCursor == null) return;
            this.setCursor(currentCursor);
            return;
        }
        Object var6_10 = null;
        if (currentCursor == null) return;
        this.setCursor(currentCursor);
    }

    private void onRegistrySelection() {
        block5: {
            Object item = this.m_wsrrRegistryCombo.getSelectedItem();
            if (item instanceof VWWSRRRegistryItem) {
                VWWSRRRegistryItem registryItem = (VWWSRRRegistryItem)item;
                try {
                    if (registryItem.isConnected()) {
                        this.m_publishButton.setEnabled(true);
                        break block5;
                    }
                    this.m_publishButton.setEnabled(false);
                }
                catch (Exception ex) {
                    this.m_publishButton.setEnabled(false);
                }
            } else {
                this.m_publishButton.setEnabled(false);
            }
        }
    }

    private String showMessage(String msg, String title, int msgType) {
        return this.showMessage(msg, title, msgType, null);
    }

    private String showMessage(String msg, String title, int msgType, Exception ex) {
        if (ex != null) {
            msg = msg == null ? new String(ex.toString()) : msg + "\n" + ex.toString();
        }
        VWMessageDialog.showOptionDialog(this.m_parentFrame, msg, title, msgType);
        return msg;
    }

    class WorkflowQuery {
        public String toString() {
            return VWResource.s_webServicesWorkflows;
        }

        public VWWSWorkflow[] findWorkflowByName(String name) throws Exception {
            Vector<VWWSWorkflow> wsWorkflows = new Vector<VWWSWorkflow>();
            if (name != null && VWWSRRWorkflowPublishPanel.this.m_session != null) {
                int queryNameLen = -1;
                if (name != null) {
                    queryNameLen = name.length();
                }
                String[] wcNames = VWWSRRWorkflowPublishPanel.this.m_session.fetchWorkClassNames(true);
                VWWorkflowSignature sig = null;
                if (wcNames != null && wcNames.length > 0) {
                    for (int i = 0; i < wcNames.length; ++i) {
                        String wcName = wcNames[i];
                        if (wcName == null) continue;
                        if (queryNameLen > 0 && wcName.length() >= queryNameLen) {
                            String s = null;
                            s = wcName.substring(0, queryNameLen);
                            if (VWStringUtils.compareIgnoreCase(s, name) != 0) continue;
                        }
                        if ((sig = VWWSRRWorkflowPublishPanel.this.m_session.fetchWorkflowSignature(wcNames[i])) == null || sig.getPartnerlinkNames() == null || sig.getPartnerlinkNames().length <= 0 || !sig.getHasMyPortType()) continue;
                        wsWorkflows.add(new VWWSWorkflow(sig));
                    }
                }
            }
            if (wsWorkflows != null && wsWorkflows.size() > 0) {
                VWWSWorkflow[] array = new VWWSWorkflow[wsWorkflows.size()];
                wsWorkflows.toArray(array);
                return array;
            }
            return null;
        }
    }
}

